/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.EditTimePanelBean;
import com.ibm.hwmca.base.ntfy.NotificationAbstractTasklet;
import com.ibm.hwmca.base.ntfy.TimeManagerPanelBean;
import com.ibm.hwmca.fw.ntfy.DuplicateNameException;
import com.ibm.hwmca.fw.ntfy.MonitoredHashMap;
import com.ibm.hwmca.fw.ntfy.NotificationService;
import com.ibm.hwmca.fw.ntfy.TimeFilter;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class TimeManagerTasklet
extends NotificationAbstractTasklet {
    private static final String TRACE_MASKT = "XNTYUMTT";
    private static final String TRACE_MASKF = "XNTYUMTF";
    private static final String TRACE_MASKD = "XNTYUMTD";

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        String command;
        String source = (String)request.getData("CommandSource");
        if (source == null) {
            source = "";
        }
        if ((command = (String)request.getData("CommandName")) == null) {
            command = "";
        }
        if (request.isInitialRequest()) {
            this.serviceInitial(request, response);
        } else if (request.isCanceled() || request.isDisposed() || command.equals("CANCEL") || command.equals("")) {
            this.serviceDisposed(request, response);
        } else if (source.equals("TimeManagerPanel")) {
            this.serviceTimeManagerPanel(request, response);
        } else if (source.equals("EditTimePanel")) {
            this.serviceEditTimePanel(request, response);
        } else if (command.equals("BounceCommand")) {
            this.serviceBounce(request, response);
        } else {
            this.unknownCommand(response, command);
        }
    }

    private void serviceInitial(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        this.errorId = (short)-32741;
        TimeManagerPanelBean bean = new TimeManagerPanelBean();
        bean.setBeanName("TimeManagerPanel");
        TreeMap times = new TreeMap();
        Map filters = NotificationService.getManager().getFilters();
        Iterator iterator = filters.keySet().iterator();
        while (iterator.hasNext()) {
            String filterName = (String)iterator.next();
            if (!(filters.get(filterName) instanceof TimeFilter)) continue;
            times.put(filterName, filters.get(filterName));
        }
        Map[] timeMaps = new Map[times.size()];
        int i = 0;
        Iterator iterator2 = times.keySet().iterator();
        while (iterator2.hasNext()) {
            String timeName = (String)iterator2.next();
            TimeFilter time = (TimeFilter)times.get(timeName);
            timeMaps[i] = new HashMap();
            timeMaps[i].put("DataMapUserName", time.getName());
            timeMaps[i].put("DataMapDesc", time.getDescription());
            ++i;
        }
        HashMap<String, Object> beanData = new HashMap<String, Object>();
        beanData.put("TimeTable", timeMaps);
        beanData.put("EditMode", Boolean.TRUE);
        bean.setData(beanData);
        response.replace("com.ibm.hwmca.base.ntfy.res.NotificationRes", "TimeManagerPanel", bean);
    }

    void serviceTimeManagerPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        this.errorId = (short)-32741;
        String command = (String)request.getData("CommandName");
        if (command.equals("AddButton")) {
            EditTimePanelBean bean = new EditTimePanelBean();
            bean.setBeanName("EditTimePanel");
            this.mode = 1;
            response.openModalChild("com.ibm.hwmca.base.ntfy.res.NotificationRes", "EditTimePanel", bean);
        } else if (command.equals("EditButton")) {
            String time = (String)request.getData("TaskletSelectedTimes");
            EditTimePanelBean bean = new EditTimePanelBean();
            bean.setBeanName("EditTimePanel");
            TimeFilter filter = (TimeFilter)NotificationService.getManager().getFilters().get(time);
            HashMap<String, Object> beanMap = new HashMap<String, Object>();
            beanMap.put("DataMapUserName", filter.getName());
            beanMap.put("DataMapDesc", filter.getDescription());
            beanMap.put("DataMapDays", filter.getDays());
            if (filter.getStartDay() != null) {
                beanMap.put("DataMapLimitDay", Boolean.TRUE);
                beanMap.put("DataMapLimitDayStart", filter.getStartDay());
                beanMap.put("DataMapLimitDayEnd", filter.getStopDay());
            } else {
                beanMap.put("DataMapLimitDay", Boolean.FALSE);
            }
            if (filter.getStartTime() != null) {
                beanMap.put("DataMapLimitTime", Boolean.TRUE);
                beanMap.put("DataMapLimitTimeStart", filter.getStartTime());
                beanMap.put("DataMapLimitTimeEnd", filter.getStopTime());
            } else {
                beanMap.put("DataMapLimitTime", Boolean.FALSE);
            }
            bean.setData(beanMap);
            this.mode = 2;
            response.openModalChild("com.ibm.hwmca.base.ntfy.res.NotificationRes", "EditTimePanel", bean);
        } else if (command.equals("DeleteButton")) {
            if (this.okToDelete((String)request.getData("TaskletSelectedTimes"))) {
                HashMap<String, String> updateMap = new HashMap<String, String>();
                updateMap.put("CommandName", "DeleteButton");
                response.update("TimeManagerPanel", updateMap);
            } else {
                response.noAction();
            }
        } else {
            this.unknownCommand(response, command);
        }
    }

    void serviceEditTimePanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        this.errorId = (short)-32740;
        String command = (String)request.getData("CommandName");
        HashMap<String, String> map = new HashMap<String, String>();
        if (command.equals("ApplyButton") || command.equals("OKButton")) {
            if (this.mode == 1) {
                map.put("CommandName", "AddButton");
            } else if (this.mode == 2) {
                map.put("CommandName", "EditButton");
            }
            TimeFilter filter = new TimeFilter((String)request.getData("DataMapUserName"), (String)request.getData("DataMapDesc"), (int[])request.getData("DataMapDays"), (Calendar)request.getData("DataMapLimitTimeStart"), (Calendar)request.getData("DataMapLimitTimeEnd"), (Calendar)request.getData("DataMapLimitDayStart"), (Calendar)request.getData("DataMapLimitDayEnd"));
            Trace.trace(TRACE_MASKF, "filter: " + filter);
            map.put("DataMapUserName", filter.getName());
            map.put("DataMapDesc", filter.getDescription());
            try {
                if (this.mode == 2) {
                    ((MonitoredHashMap)NotificationService.getManager().getFilters()).replace(filter.getName(), filter);
                } else {
                    NotificationService.getManager().getFilters().put(filter.getName(), filter);
                }
                this.mode = 2;
                if (command.equals("ApplyButton")) {
                    response.noAction();
                } else {
                    response.dispose("EditTimePanel");
                }
                this.bounceUpdate("TimeManagerPanel", map);
            }
            catch (DuplicateNameException dne) {
                if (this.mode == 1) {
                    this.duplicateMessage(filter.getName());
                    response.noAction();
                }
            }
        } else if (command.equals("CancelButton")) {
            response.dispose("EditUserPanel");
        } else {
            this.unknownCommand(response, command);
        }
    }
}

